
package net.kldp.logviewer.db.common.pool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import net.kldp.logviewer.common.log.LogViews;

import org.apache.log4j.Logger;


/**
 * <PRE>
 * 
 * Title : Connection Pool ü ʱȭ     Ҽ ֵ ش.
 * 
 * Comment :
 * 
 * History :
 * 
 * </PRE>
 * 
 * @version 0.1, 2005. 9. 15.
 * @author henry
 */
public class ConnectionResource implements ConnectionContext {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LogViews
			.getLogger(ConnectionResource.class);

	/** Data Base Connection pool name Ѵ */
	private String poolName= "";	
	private Connection connection = null;
	private boolean isAutoCommit = false;

	public ConnectionResource() {}
	
	/** 
	 * Connection Pool Name Ѵ.
	 * 
	 * @param name
	 */
	protected void setPoolName(String name) {
		this.poolName = name;
	}

	/**
	 * Connection pool object ʱȭѴ.
	 * 
	 * @param isAutoCommit transaction  Ѵ.
	 * @throws Exception
	 */
	public void init(boolean isAutoCommit) throws Exception {
		this.isAutoCommit = isAutoCommit;
		
		try {
			connection = DriverManager.getConnection("jdbc:apache:commons:dbcp:" + poolName);
			
		} catch(SQLException sqle) {

			// Connection ü Ƿ Connection Pool ü Ѵ.
			ConnectionInitialize conInit = new ConnectionInitialize();
			conInit.init(poolName);
			
			//  ̸ ̹ ٽ ã´.
			connection = DriverManager.getConnection("jdbc:apache:commons:dbcp:" + poolName);
		}
		
		// Autocommit  Ұ 
		if (isAutoCommit) {
		    connection.setAutoCommit(true);
		} else {
		    connection.setAutoCommit(false);
	//	    connection.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);
		}
		
		if (connection == null) {
			throw new Exception("Connection Pool ü ʱȭ ϴµ ߽ϴ.");
		}
		
//		logger.debug("Connection Pool ü ʱȭ ߽ϴ.");
	}

	/**
	 * Connection return
	 */
	public Connection getConnection() {
		return connection;
	}

	/**
	 * rollback
	 */
	public void rollback() {
		if (!isAutoCommit) {
			if (connection != null) {
				try { connection.rollback(); } catch (Exception e) {}
			} // connection if end
		} // transaction end if
	}

	/**
	 * commit
	 */
	public void commit() {
		if (!isAutoCommit) {
			if (connection != null) {
				try { connection.commit(); } catch (Exception e) {}
			} // connection if end
		} // transaction end if
	}

	/**
	 * release
	 */
	public void release() {
		if (connection != null) {
			if (!isAutoCommit) {
				try { connection.setAutoCommit(true); } catch (Exception e) {}
			}
			try { connection.close(); } catch (Exception e) {}
		}
	}
	
    public void printDataSourceStats() throws SQLException {
//        BasicDataSource bds = (BasicDataSource) ds;
//        System.out.println("NumActive: " + bds.getNumActive());
//        System.out.println("NumIdle: " + bds.getNumIdle());
    	
        
    }

//    public static void shutdownDataSource(DataSource ds) throws SQLException {
//        BasicDataSource bds = (BasicDataSource) ds;
//        bds.close();
//    }
}
